unit UDemoADOAppRcd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MRViewer, Db, DBTables, ExtCtrls, ComCtrls, AdoIntmr;

type
  TForm1 = class(TForm)
    MRViewer: TMRViewer;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Bevel1: TBevel;
    ProgressBar: TProgressBar;
    Button2: TButton;
    Panel1: TPanel;
    Label6: TLabel;
    Label7: TLabel;
    Button3: TButton;
    RGType: TRadioGroup;
    RGReport: TRadioGroup;
    procedure Button1Click(Sender: TObject);
    procedure MRViewerProgress(Position: Integer);
    procedure MRViewerActivateConnection(var Connection: _Connection;
      var Accept: Boolean);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure MRViewerGetDataRecordSet(Name: String; IsMain: Boolean;
      DetailInternalName, SQL: String; var FDataSet: _Recordset);
    procedure RGReportClick(Sender: TObject);
  private
    { Private declarations }
    AppConnection: _Connection;
    AppRecordSet: _RecordSet;

    ConnCreated: Boolean;
    RcdOpened: Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.Button1Click(Sender: TObject);
begin
    if not ConnCreated then
       ShowMessage('You must create ADO connection and open recordset at first.')
    else if not RcdOpened then
       ShowMessage('You must open recordset.')
    else
        try
            if RGType.ItemIndex = 0 then
            begin
               case RGReport.ItemIndex of
                 0: MRViewer.LoadReport('..\..\Reports\DemoGraph1.mrp');
                 1: MRViewer.LoadReport('..\..\Reports\DemoGraph2.mrp');
                 2: MRViewer.LoadReport('..\..\Reports\DemoGraph3.mrp');
               end;
            end
            else
            begin
               case RGReport.ItemIndex of
                 0: MRViewer.LoadReport('..\..\Reports\Demo1.mrp');
                 1: MRViewer.LoadReport('..\..\Reports\Demo2.mrp');
                 2: MRViewer.LoadReport('..\..\Reports\Demo3.mrp');
               end;
            end;

            MRViewer.Preview;
        finally
            MRViewer.UnLoadReport;
        end;
end;

procedure TForm1.MRViewerProgress(Position: Integer);
begin
    ProgressBar.Position := Position;
end;

procedure TForm1.MRViewerActivateConnection(var Connection: _Connection;
  var Accept: Boolean);
begin
    Connection := AppConnection;
    Accept := True;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
     AppConnection := CoConnection.Create;
     AppConnection.Open('DSN=MarshalDemo', '', '', -1);
     ConnCreated := True;
     ShowMessage('ADO connection was created.');
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
    if not ConnCreated then
       ShowMessage('You must create ADO connection at first.')
    else
    begin
        AppRecordSet := nil;
        AppRecordSet := CoRecordSet.Create;

        case RGReport.ItemIndex of
           0: AppRecordSet.Open('select * from customer', AppConnection, adOpenKeySet, adLockBatchOptimistic, adCmdText);

           1: AppRecordSet.Open('select orders.ItemsTotal as ItemsTotal,orders.OrderNo as OrderNo,orders.SaleDate as SaleDate,customer.Addr1 as Addr1,customer.City as City,customer.Country as Country,customer.CustNo as CustNo,customer.Company as Company '+
                                'from orders  Left outer join customer on orders.CustNo = customer.CustNo ' +
                                'order by customer.CustNo, OrderNo',
                                AppConnection, adOpenKeySet, adLockBatchOptimistic, adCmdText);
           2: AppRecordSet.Open('select * from vendors', AppConnection, adOpenKeySet, adLockBatchOptimistic, adCmdText);
        end;

        RcdOpened := True; 
        ShowMessage('ADO Recordset was opened.');
    end;
end;

procedure TForm1.MRViewerGetDataRecordSet(Name: String; IsMain: Boolean;
  DetailInternalName, SQL: String; var FDataSet: _Recordset);
begin
    if IsMain then
       FDataSet := AppRecordSet
    else
       FDataSet := nil;
end;

procedure TForm1.RGReportClick(Sender: TObject);
begin
    RcdOpened := False;
end;

end.
